Script.Load( "Data\\Script\\MapTools\\Main.lua" )
------------------------------------------------------------------------------
function InitDiplomacy()
	SetFriendly(1,2)
	SetFriendly(1,5)
		
	SetHostile(4,1)
	SetHostile(4,2)
	SetHostile(4,5)
	SetHostile(6,1)
	SetHostile(6,2)
	SetHostile(6,5)
	SetHostile(7,1)

	end
------------------------------------------------------------------------------
function InitResources()
    -- set some resources
    AddStone(0)
    AddClay(0)
    AddGold(0)
    AddSulfur(0)
    AddIron(0)
    AddWood(0)
    end
------------------------------------------------------------------------------
function InitTechnologies()
	ForbidTechnology(Technologies.GT_Matchlock)
	ForbidTechnology(Technologies.GT_PulledBarrel)
	
	ResearchTechnology(Technologies.GT_Mercenaries)
	ResearchTechnology(Technologies.GT_StandingArmy)
	ResearchTechnology(Technologies.GT_Tactics)
	
	ResearchTechnology(Technologies.GT_Construction)
	
	ResearchTechnology(Technologies.GT_Alchemy)
	
	ResearchTechnology(Technologies.GT_Literacy)
	
	ResearchTechnology(Technologies.GT_Mathematics)
	ResearchTechnology(Technologies.GT_Binocular)
	
    end
------------------------------------------------------------------------------
function InitWeatherGfxSets()
	if FinalAttackComming ~= true then
		Display.SetRenderUseGfxSets(1)
		
		Display.GfxSetSetSkyBox(1, 0.0, 1.0, "YSkyBox03")
		Display.GfxSetSetSnowStatus(1, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(1, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams(1, 0.0, 1.0, 1, 170,172,172, 7000,30000)
		Display.GfxSetSetLightParams(1,  0.0, 1.0, 40, -15, -25,  167,167,209,  255,226,226)
		
		 Display.GfxSetSetSkyBox(3, 0.0, 1.0, "YSkyBox01")
		Display.GfxSetSetSnowStatus(3, 0, 1.0, 1)
		Display.GfxSetSetSnowEffectStatus(3, 0.0, 0.8, 1)
		Display.GfxSetSetFogParams(3, 0.0, 1.0, 1, 152,172,182, 4000,30000)
		Display.GfxSetSetLightParams(3,  0.0, 1.0,  40, -15, -25,  100,110,110, 250,250,250)
		
		Display.GfxSetSetSkyBox(2, 0.0, 1.0, "YSkyBox04")
		 Display.GfxSetSetRainEffectStatus(2, 0.0, 1.0, 1)
		 Display.GfxSetSetSnowStatus(2, 0, 1.0, 0)
		 Display.GfxSetSetSnowEffectStatus(2, 0.0, 0.8, 0)
		 Display.GfxSetSetFogParams(2, 0.0, 1.0, 1, 102,132,142, 3500,30000)
		 Display.GfxSetSetLightParams(2,  0.0, 1.0, 40, -15, -25,  120,110,110,  255,254,230)
 
	else
		Display.SetRenderUseGfxSets(1)
		
		Display.GfxSetSetSkyBox(1, 0.0, 1.0, "YSkyBox03")
		Display.GfxSetSetSnowStatus(1, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(1, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams(1, 0.0, 1.0, 1, 170,172,172, 7000,30000)
		Display.GfxSetSetLightParams(1,  0.0, 1.0, 40, -15, -25,  167,167,209,  255,226,226)
		
		Display.GfxSetSetSkyBox(2, 0.0, 1.0, "YSkyBox04")
		Display.GfxSetSetRainEffectStatus(2, 0.0, 1.0, 1)
		Display.GfxSetSetSnowStatus(2, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(2, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams( 2, 0.0, 1.0, 1, 0, 140, 80, 0,30000)
		Display.GfxSetSetLightParams( 2,  0.0, 1.0, 40, -15, -50, 120,130,255, 255,254,230)
		
		Display.GfxSetSetSkyBox(3, 0.0, 1.0, "YSkyBox01")
		Display.GfxSetSetSnowStatus(3, 0, 1.0, 1)
		Display.GfxSetSetSnowEffectStatus(3, 0.0, 0.8, 1)
		Display.GfxSetSetFogParams(3, 0.0, 1.0, 1, 152,172,182, 4000,30000)
		Display.GfxSetSetLightParams(3,  0.0, 1.0,  40, -15, -25,  100,110,110, 250,250,250)
		
	end
    end
------------------------------------------------------------------------------
function InitWeather()
	AddPeriodicSummer(10)
end

------------------------------------------------------------------------------
function InitPlayerColorMapping()

	Display.SetPlayerColorMapping(1,PLAYER_COLOR)
	
	
	if CitywallsPlayercolor ~= true then
		Display.SetPlayerColorMapping(3,FRIENDLY_COLOR1)
		Display.SetPlayerColorMapping(2,FRIENDLY_COLOR1)
	else
		Display.SetPlayerColorMapping(3,PLAYER_COLOR)
		Display.SetPlayerColorMapping(2,NEPHILIM_COLOR)
	end
	
	Display.SetPlayerColorMapping(4,EVIL_GOVERNOR_COLOR)
	Display.SetPlayerColorMapping(6,NEPHILIM_COLOR)
	
	Display.SetPlayerColorMapping(7,EVIL_GOVERNOR_COLOR)
	
end
	
------------------------------------------------------------------------------
function FirstMapAction()

	-- load scripts
	IncludeLocals("army_attackers")
	IncludeLocals("army_attackers2")
	IncludeLocals("army_cityDefense")
	IncludeLocals("army_finalAttack")
	IncludeLocals("army_firstAttack")
	IncludeLocals("army_mirai")

	IncludeLocals("briefing_attackers")
	IncludeLocals("briefing_attackersGone")
	IncludeLocals("briefing_defend")
	IncludeLocals("briefing_finalAttack")
	IncludeLocals("briefing_mirai")
	IncludeLocals("briefing_prelude")
	IncludeLocals("briefing_riflemen")
	IncludeLocals("briefing_siege")

	IncludeLocals("gameControl")

	IncludeLocals("player_2")
	IncludeLocals("player_4")
	IncludeLocals("player_5")
	IncludeLocals("player_6")

	IncludeLocals("quest_buildUp")
	IncludeLocals("quest_defend")
	IncludeLocals("quest_finalAttack")
	IncludeLocals("quest_firstAttackersWave")
	IncludeLocals("quest_mirai")
	IncludeLocals("quest_rescueCity")
	--AnSu: Needed to update the QuestInformation
	IncludeLocals("quest_killFirstAttackers")
	
	IncludeLocals("Towerlimit")
	IncludeLocals("quest_EntitiesOutside")
	IncludeLocals("TradeBalancer")
	
	IncludeLocals("GetRandom")
	IncludeLocals("GetCirclePosition")
	IncludeLocals("GetAngleBetween")
	IncludeLocals("CopyTable")
	IncludeLocals("EntityIDChangedHelper")
	IncludeLocals("GetDistance")
	IncludeLocals("IsEntityOfType")
	IncludeLocals("IsValidPosition")
	IncludeLocals("LuaObject")
	IncludeLocals("TargetFilter")
	IncludeLocals("TriggerFix")
	IncludeLocals("UnlimitedArmy")
	IncludeLocals("UnlimitedArmySpawnGenerator")
	
	IncludeLocals("army_kadricamp")
	
	Score.Player[0] = {buildings=0, all=0}
	
	math.randomseed(XGUIEng.GetSystemTime())
	
	
	OverWriteFuncs()
	EntityIdChangedHelper.Init()
	TradeBlancerInit()
	CreateQuestEntitiesOutside()
	ActivateTowerLimit(9)	
	
	HistoryFlag = GoldHistoryCheck()

	LocalMusic.UseSet = MEDITERANEANMUSIC
	
	Logic.SetModelAndAnimSet(GetID("GoldRock"),Models.XD_Sulfur1,nil)
	
	CreateWoodPile("woodpile",10000000)

    -- debugging stuff
    --EnableDebugging()
    
    -- Start simple jobs
        
	-- String
	String.Init("CM02_03_BigCity")
	
	function
	LocalMusic.CallbackSettlerKilled(_HurterPlayerID, _HurtPlayerID)
	
	local PlayerID = GUI.GetPlayerID()
	
	if _HurterPlayerID ~= _HurtPlayerID and PlayerID == _HurtPlayerID  then		
			if LocalMusic.LastBattleMusicStarted < Logic.GetTime() then					
				if Logic.IsEntityInCategory(_HurterPlayerID,EntityCategories.EvilLeader) == 1 then
					LocalMusic.BattlesOnTheMap = 2
				else
					LocalMusic.BattlesOnTheMap = 1
				end
				LocalMusic.LastBattleMusicStarted = Logic.GetTime() + 127
				LocalMusic.SongLength = 0
			end
		end
	end
	
	Cutscenes = {}
	Cutscenes[INTROCUTSCENE] = "INTRO"	
	Cutscenes[THRESHOLDONECUTSCENE] = "CITY"
	Cutscenes[THRESHOLTWOCUTSCENE] = "FOG"
	Cutscenes[MISSIONCOMPLETECUTSCENE] = "LEAVING"
	
			
	IncludeLocals("Cutscene_" .. Cutscenes[INTROCUTSCENE])
	IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLDONECUTSCENE])	
	IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLTWOCUTSCENE])	
	IncludeLocals("Cutscene_" .. Cutscenes[MISSIONCOMPLETECUTSCENE])
	IncludeLocals("CutScene_ClosedDoors")
	
	CreateDynamicFog("LeftFog",0)
	
	CreateDynamicFog("MiddleFog", 0)
	CreateDynamicFog("RightFog", 0)
	-- cutscene
--	StartCutscene("Intro",start1stChapter)
	StartCutscene(Cutscenes[INTROCUTSCENE],CreateBriefingPrelude);

end

function GoldHistoryCheck()
	if XNetwork.Manager_IsNATReady then
		return 1
	else
		return 0
	end
end

function openChest()
	Message("Ihr habt eine Schatztruhe der Banditen gefunden! @cr Darin waren 5.000 Stück Eisen!")
	Logic.AddToPlayersGlobalResource(1,ResourceType.IronRaw,5000)
end

function qmod(a, b)
	return a - math.floor(a/b)*b
end

function Int2Float(num)
	if(num == 0) then
		return 0
	end

	local sign = 1

	if(num < 0) then
		num = 2147483648 + num
		sign = -1
	end

	local frac = qmod(num, 8388608)
	local headPart = (num-frac)/8388608
	local expNoSign = qmod(headPart, 256)
	local exp = expNoSign-127
	local fraction = 1
	local fp = 0.5
	local check = 4194304
	for i = 23, 0, -1 do
		if(frac - check) > 0 then
			fraction = fraction + fp
			frac = frac - check
		end
		check = check / 2
		fp = fp / 2
	end
	return fraction * math.pow(2, exp) * sign
end

function bitsInt(num)
	local t={}
	while num>0 do
		rest=qmod(num, 2)
		table.insert(t,1,rest)
		num=(num-rest)/2
	end
	table.remove(t, 1)
	return t
end

function bitsFrac(num, t)
	for i = 1, 48 do
		num = num * 2
		if(num >= 1) then
			table.insert(t, 1)
			num = num - 1
		else
			table.insert(t, 0)
		end
		if(num == 0) then
			return t
		end
	end
	return t
end

function Float2Int(fval)
	if(fval == 0) then
		return 0
	end

	local signed = false
	if(fval < 0) then
		signed = true
		fval = fval * -1
	end
	local outval = 0;
	local bits
	local exp = 0
	if fval >= 1 then
		local intPart = math.floor(fval)
		local fracPart = fval - intPart
		bits = bitsInt(intPart)
		exp = table.getn(bits)
		bitsFrac(fracPart, bits)
	else
		bits = {}
		bitsFrac(fval, bits)
		while(bits[1] == 0) do
			exp = exp - 1
			table.remove(bits, 1)
		end
		exp = exp - 1
		table.remove(bits, 1)
	end

	local bitVal = 4194304
	local start = 1

	for bpos = start, 23 do
		local bit = bits[bpos]
		if(not bit) then
			break;
		end

		if(bit == 1) then
			outval = outval + bitVal
		end
		bitVal = bitVal / 2
	end

	outval = outval + (exp+127)*8388608

	if(signed) then
		outval = outval - 2147483648
	end

	return outval;
end

function GetLeaderOfSoldier(_SoldierID)
	if HistoryFlag == 1 then
		return Logic.GetEntityScriptingValue(_SoldierID, 66)
	else
		return Logic.GetEntityScriptingValue(_SoldierID, 69)
	end
end

function SizeIndex()
	if HistoryFlag == 1 then
		return -29
	elseif HistoryFlag == 0 then
		return -33
	end
end

function OverWriteFuncs()
	VoiceIndex = 1
	StartSpeech = function(_key)

		if _key ~= nil then

			local tablePos = string.find(_key, "/")
			if tablePos ~= nil then
				Stream.Start("Voice\\"..string.sub(_key, 1, tablePos-1).."\\"..string.sub(_key, tablePos + 1, -1)..".mp3", 150)
			else
				Stream.Start(Folders.Map.."customvoices/ScoutSiegeTeil"..VoiceIndex..".mp3", 350)
				VoiceIndex = VoiceIndex + 1
			end
		end

	end
	
	function CreateChest(_position,_callback)
		chestCounter = chestCounter +1
		local name = "_chest_"..chestCounter
		local entityId = Logic.CreateEntity(Entities.XD_ChestClose,_position.X,_position.Y,90,0)
		Logic.SetEntityName(entityId, name)
		local chestData = {}
		chestData.name 		= name
		chestData.state		= CHEST_CLOSED
		if _callback == nil then
			chestData.callback 	= chestDefaultCallback
		else
			chestData.callback 	= _callback
			end
		table.insert(chestControl.list,chestData)
		return entityId
	end
	
		function GUIQuestTools.UpdateQuestInformationTooltip()
	XGUIEng.SetText("QuestInformationTooltipText", GUIQuestTools.QuestTooltip, 1)	 
	end
end

function CreateWoodPile( _posEntity, _resources )
    assert( type( _posEntity ) == "string" )
    assert( type( _resources ) == "number" )
    gvWoodPiles = gvWoodPiles or {
        JobID = StartSimpleJob("ControlWoodPiles"),
    }
    local pos = GetPosition( _posEntity )
    local pile_id = Logic.CreateEntity( Entities.XD_Rock3, pos.X, pos.Y, 0, 0 )

    SetEntityName( pile_id, _posEntity.."_WoodPile" )

    local newE = ReplaceEntity( _posEntity, Entities.XD_ResourceTree )
    Logic.SetModelAndAnimSet(newE, Models.XD_SignalFire1)
    Logic.SetResourceDoodadGoodAmount( GetEntityId( _posEntity ), _resources*10 )
    Logic.SetModelAndAnimSet(pile_id, Models.Effects_XF_ChopTree)
    table.insert( gvWoodPiles, { ResourceEntity = _posEntity, PileEntity = _posEntity.."_WoodPile", ResourceLimit = _resources*9 } )
end

function ControlWoodPiles()
    for i = table.getn( gvWoodPiles ),1,-1 do
        if Logic.GetResourceDoodadGoodAmount( GetEntityId( gvWoodPiles[i].ResourceEntity ) ) <= gvWoodPiles[i].ResourceLimit then
            DestroyWoodPile( gvWoodPiles[i], i )
        end
    end
end

function DestroyWoodPile( _piletable, _index )
    local pos = GetPosition( _piletable.ResourceEntity )
    DestroyEntity( _piletable.ResourceEntity )
    DestroyEntity( _piletable.PileEntity )
    Logic.CreateEffect( GGL_Effects.FXCrushBuilding, pos.X, pos.Y, 0 )
    table.remove( gvWoodPiles, _index )
end